<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    * 	Classe che restituisce i link scritti con Geecom
    */

    class GestoreHtaccess {
	public static function htaccesRedirectsHttpsWWW() {
            return "RewriteEngine on
                RewriteCond %{HTTPS} =off [OR]
                RewriteCond %{HTTP_HOST} !^www\. [OR]
                RewriteCond %{THE_REQUEST} ^[A-Z]{3,9}\ /index\.(html|php)
                RewriteCond %{HTTP_HOST} ^(www\.)?(.+)$
                RewriteCond %{REQUEST_URI} !^/[0-9]+\..+\.cpaneldcv$
                RewriteCond %{REQUEST_URI} !^/[A-F0-9]{32}\.txt(?:\ Comodo\ DCV)?$
                RewriteCond %{REQUEST_URI} !^/\.well-known/pki-validation/[A-F0-9]{32}\.txt(?:\ Comodo\ DCV)?$
                RewriteRule ^(index\.(html|php))|(.*)$ https://www.%2/$3 [R=301,L]
                ";
	}

        public static function htaccesRedirectsHttps() {
            return "RewriteEngine on
                RewriteCond %{HTTPS} =off [OR]
                RewriteCond %{THE_REQUEST} ^[A-Z]{3,9}\ /index\.(html|php)
                RewriteCond %{HTTP_HOST} ^(www\.)?(.+)$
                RewriteCond %{REQUEST_URI} !^/[0-9]+\..+\.cpaneldcv$
                RewriteCond %{REQUEST_URI} !^/[A-F0-9]{32}\.txt(?:\ Comodo\ DCV)?$
                RewriteCond %{REQUEST_URI} !^/\.well-known/pki-validation/[A-F0-9]{32}\.txt(?:\ Comodo\ DCV)?$
                RewriteRule ^(index\.(html|php))|(.*)$ https://%2/$3 [R=301,L]
                ";
	}
        
	public static function htaccessSeo($cartellaAmministrativa) {
            return "RewriteEngine on
                RewriteCond %{REQUEST_FILENAME} !-f
                RewriteCond %{REQUEST_FILENAME} !-d
                RewriteCond %{REQUEST_FILENAME}.php -f
                RewriteRule ^$cartellaAmministrativa $cartellaAmministrativa/index.php [QSA,L]
                RewriteRule ^$cartellaAmministrativa/(.*)$ $cartellaAmministrativa/$1 [QSA,L]
                RewriteRule ^controller/(.*)$ controller/$1 [QSA,L]
                RewriteRule ^template/(.*)$ template/$1 [QSA,L]
                RewriteRule ^plugins/(.*)$ plugins/$1 [QSA,L]
                RewriteRule ^js/(.*)$ js/$1 [QSA,L]
                RewriteRule ^immagini/(.*)$ immagini/$1 [QSA,L]
                RewriteRule ^file/(.*)$ file/$1 [QSA,L]
                RewriteRule ^categoria-(.*)$ cerca.php?tipoRicerca=categoria&chiaveRicerca=$1 [QSA,L]
                RewriteRule ^cerca.php(.*)$ cerca.php$1 [QSA,L]
                RewriteRule ^scaricaFile.php(.*)$ scaricaFile.php$1 [QSA,L]
                RewriteRule ^prod-(.*)$ prodotto.php?alias=$1 [QSA,L]
                RewriteRule ^carrello.php(.*)$ carrello.php$1 [QSA,L]
                RewriteRule ^acquistoEffettuato.php(.*)$ acquistoEffettuato.php$1 [QSA,L]
                RewriteRule ^mappa-sito.xml(.*)$ mappa-sito.xml$1 [QSA,L]
                RewriteRule ^robots.txt robots.txt [QSA,L]
                RewriteRule ^(.*)$ index.php?alias=$1 [QSA]
                ";
	}

	public static function htaccessHttpsESeo($cartellaAmministrativa,$reindirizzamentoHttps) {
            $bloccoReindirizzamento = ($reindirizzamentoHttps=="httpswww") ? GestoreHtaccess::htaccesRedirectsHttpsWWW() : GestoreHtaccess::htaccesRedirectsHttps();
            return "$bloccoReindirizzamento

                RewriteCond %{REQUEST_FILENAME} !-f
                RewriteCond %{REQUEST_FILENAME} !-d
                RewriteCond %{REQUEST_FILENAME}.php -f
                RewriteRule ^$cartellaAmministrativa $cartellaAmministrativa/index.php [QSA,L]
                RewriteRule ^$cartellaAmministrativa/(.*)$ $cartellaAmministrativa/$1 [QSA,L]
                RewriteRule ^controller/(.*)$ controller/$1 [QSA,L]
                RewriteRule ^template/(.*)$ template/$1 [QSA,L]
                RewriteRule ^plugins/(.*)$ plugins/$1 [QSA,L]
                RewriteRule ^js/(.*)$ js/$1 [QSA,L]
                RewriteRule ^immagini/(.*)$ immagini/$1 [QSA,L]
                RewriteRule ^file/(.*)$ file/$1 [QSA,L]
                RewriteRule ^categoria-(.*)$ cerca.php?tipoRicerca=categoria&chiaveRicerca=$1 [QSA,L]
                RewriteRule ^cerca.php(.*)$ cerca.php$1 [QSA,L]
                RewriteRule ^scaricaFile.php(.*)$ scaricaFile.php$1 [QSA,L]
                RewriteRule ^prod-(.*)$ prodotto.php?alias=$1 [QSA,L]
                RewriteRule ^carrello.php(.*)$ carrello.php$1 [QSA,L]
                RewriteRule ^acquistoEffettuato.php(.*)$ acquistoEffettuato.php$1 [QSA,L]
                RewriteRule ^mappa-sito.xml(.*)$ mappa-sito.xml$1 [QSA,L]
                RewriteRule ^robots.txt robots.txt [QSA,L]
                RewriteRule ^(.*)$ index.php?alias=$1 [QSA]
                ";
	}
        
        public static function stampaCodiceAttivaCache() {
            return "## Impostazioni cache ##
                <IfModule mod_expires.c>
                ExpiresActive On
                ExpiresByType image/jpg \"access 1 year\"
                ExpiresByType image/jpeg \"access 1 year\"
                ExpiresByType image/gif \"access 1 year\"
                ExpiresByType image/png \"access 1 year\"
                ExpiresByType image/svg \"access 1 year\"
                ExpiresByType text/css \"access 1 month\"
                ExpiresByType application/x-javascript \"access 1 month\"
                ExpiresDefault \"access 1 month\"
                </IfModule>
                ## Impostazioni cache ##";
	}
    }